/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.internal.indexer.CallPath;
import com.aptana.editor.php.internal.indexer.FunctionPathReference;
import com.aptana.editor.php.internal.indexer.StaticPathReference;
import com.aptana.editor.php.internal.indexer.VariablePathReference;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AbstractPathReference {
    private CallPath path;

    protected AbstractPathReference(CallPath path) {
        this.path = path;
    }

    public CallPath getPath() {
        return this.path;
    }

    public void write(DataOutputStream da) throws IOException {
        da.writeInt(this.getKind());
        boolean has = this.path != null;
        da.writeBoolean(has);
        if (has) {
            this.path.write(da);
        }
        this.internalWrite(da);
    }

    protected static CallPath readPathOrNull(DataInputStream di) throws IOException {
        if (di.readBoolean()) {
            return new CallPath(di);
        }
        return null;
    }

    protected abstract int getKind();

    protected abstract void internalWrite(DataOutputStream var1) throws IOException;

    public static AbstractPathReference read(DataInputStream di) throws IOException {
        int readInt = di.readInt();
        switch (readInt) {
            case 2: {
                return new FunctionPathReference(di);
            }
            case 3: {
                return new VariablePathReference(di);
            }
            case 5: {
                return new StaticPathReference(di);
            }
        }
        throw new IllegalArgumentException("unknown path reference:" + readInt);
    }
}

